<?php

namespace App\Http\Controllers;

use App\Models\Vault;
use Illuminate\Http\Request;

class VaultTrackingController extends Controller
{
    public function index()
    {
        return view('tracking.index');
    }

    public function show(Request $request)
    {
        $request->validate([
            'tracking_number' => 'required|string',
        ]);

        $vault = Vault::where('tracking_number', $request->tracking_number)->first();

        if (!$vault) {
            return redirect()->back()->with('error', 'Vault not found.');
        }

        return view('tracking.show', compact('vault'));
    }
}
