<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Vault extends Model
{
    use HasFactory;


    protected $fillable = [
        'tracking_number',
        'owner_name',
        'next_of_kin',
        'day_price',
        'month_price',
        'date_of_deposit',
        'category',
        'items',
        'weight',
        'quantity',
        'total_value',
        'description',
        'status',
        'image',
    ];
    public function getVaultInfo($trackingNumber)
    {
        return $this->where('tracking_number', $trackingNumber)->first();
    }
}
