@extends('layouts.amaster')

@section('title', 'Edit Vault')

@section('content')

<main>
    <div class="container-fluid">
        <!-- Breadcrumb start -->
        <div class="m-1 row">
            <div class="col-12">
                <h4 class="main-title">Edit Vault</h4>
                <ul class="mb-3 app-line-breadcrumbs">
                    <li>
                        <a href="{{ route('admin.vaults.index') }}" class="f-s-14 f-w-500">
                            <span>
                                <i class="ph-duotone ph-stack f-s-16"></i> Vaults
                            </span>
                        </a>
                    </li>
                </ul>
            </div>
        </div>
        <!-- Breadcrumb end -->

        <!-- Vault edit form start -->
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="px-0 card-body">
                        <div class="col-lg-8 form-contentbox">
                            <div class="form-container">
                                <form class="app-form" method="POST" action="{{ route('admin.vaults.update', $vault->id) }}" enctype="multipart/form-data">
                                    @csrf
                                    @method('PUT')

                                    <div class="row">
                                        <div class="col-12">
                                            <div class="mb-5 text-center text-lg-start">
                                                <h2 class="text-primary f-w-600">Edit Vault #{{ $vault->tracking_number }}</h2>
                                            </div>
                                        </div>

                                        <!-- Tracking Number -->
                                        <div class="mb-3 col-md-6">
                                            <label class="form-label">Tracking Number</label>
                                            <input type="text" class="form-control" name="tracking_number" value="{{ old('tracking_number', $vault->tracking_number) }}" required>
                                        </div>

                                        <!-- Owner Name -->
                                        <div class="mb-3 col-md-6">
                                            <label class="form-label">Owner Name</label>
                                            <input type="text" class="form-control" name="owner_name" value="{{ old('owner_name', $vault->owner_name) }}" required>
                                        </div>

                                        <!-- Next of Kin -->
                                        <div class="mb-3 col-md-6">
                                            <label class="form-label">Next of Kin</label>
                                            <input type="text" class="form-control" name="next_of_kin" value="{{ old('next_of_kin', $vault->next_of_kin) }}">
                                        </div>

                                        <!-- Day Price -->
                                        <div class="mb-3 col-md-3">
                                            <label class="form-label">Day Price</label>
                                            <input type="number" step="0.01" class="form-control" name="day_price" value="{{ old('day_price', $vault->day_price) }}">
                                        </div>

                                        <!-- Month Price -->
                                        <div class="mb-3 col-md-3">
                                            <label class="form-label">Month Price</label>
                                            <input type="number" step="0.01" class="form-control" name="month_price" value="{{ old('month_price', $vault->month_price) }}">
                                        </div>

                                        <!-- Date of Deposit -->
                                        <div class="mb-3 col-md-6">
                                            <label class="form-label">Date of Deposit</label>
                                            <input type="date" class="form-control" name="date_of_deposit" value="{{ old('date_of_deposit', $vault->date_of_deposit) }}" required>
                                        </div>

                                        <!-- Category -->
                                        <div class="mb-3 col-md-6">
                                            <label class="form-label">Category</label>
                                            <input type="text" class="form-control" name="category" value="{{ old('category', $vault->category) }}">
                                        </div>

                                        <!-- Items -->
                                        <div class="mb-3 col-12">
                                            <label class="form-label">Items</label>
                                            <textarea class="form-control" name="items">{{ old('items', $vault->items) }}</textarea>
                                        </div>

                                        <!-- Weight -->
                                        <div class="mb-3 col-md-4">
                                            <label class="form-label">Weight (kg)</label>
                                            <input type="number" step="0.01" class="form-control" name="weight" value="{{ old('weight', $vault->weight) }}">
                                        </div>

                                        <!-- Quantity -->
                                        <div class="mb-3 col-md-4">
                                            <label class="form-label">Quantity</label>
                                            <input type="number" class="form-control" name="quantity" value="{{ old('quantity', $vault->quantity) }}">
                                        </div>

                                        <!-- Total Value -->
                                        <div class="mb-3 col-md-4">
                                            <label class="form-label">Total Value</label>
                                            <input type="number" step="0.01" class="form-control" name="total_value" value="{{ old('total_value', $vault->total_value) }}">
                                        </div>

                                        <!-- Description -->
                                        <div class="mb-3 col-12">
                                            <label class="form-label">Description</label>
                                            <textarea class="form-control" name="description">{{ old('description', $vault->description) }}</textarea>
                                        </div>

                                        <!-- Status -->
                                        <div class="mb-3 col-md-6">
                                            <label class="form-label">Status</label>
                                            <select class="form-control" name="status">
                                                <option value="stored" {{ $vault->status == 'stored' ? 'selected' : '' }}>Stored</option>
                                                <option value="released" {{ $vault->status == 'released' ? 'selected' : '' }}>Released</option>
                                            </select>
                                        </div>

                                        <!-- Image -->
                                        <div class="mb-3 col-md-6">
                                            <label class="form-label">Vault Image</label>
                                            <input type="file" class="form-control" name="image">
                                            @if($vault->image)
                                                <small>Current Image:</small><br>
                                                <img src="{{ asset('storage/' . $vault->image) }}" alt="Vault Image" style="max-width:150px;">
                                            @endif
                                        </div>

                                        <!-- Submit Button -->
                                        <div class="mb-3 col-12">
                                            <button type="submit" class="btn btn-primary w-100">Update Vault</button>
                                        </div>

                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Vault edit form end -->
    </div>
</main>

@endsection
