
@extends('layouts.amaster')

@section('title', ' Dashboard')

@section('content')

@if(session('success'))
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        {{ session('success') }}
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
@endif





<main>

    <div class="container-fluid">
<!-- Breadcrumb start -->
<div class="m-1 row">
<div class="col-12 ">
    <h4 class="main-title">Users</h4>
    <ul class="mb-3 app-line-breadcrumbs">
        <li class="">
            <a href="#" class="f-s-14 f-w-500">
          <span>
            <i class="ph-duotone ph-stack f-s-16"></i>
          </span>
            </a>


        </li>
    </ul>
</div>
</div>
<!-- Breadcrumb end -->
<a href="{{ route('admin.vaults.create') }}" class="mb-3 btn btn-primary">
    Add New User
</a>
<!-- Ticket start -->
<div class="row ticket-app">



<!-- ticket table-->
<div class="col-12">
    <div class="card">
        <div class="px-0 card-body">
            <div class="table-responsive app-scroll app-datatable-default">
                <table class="w-100 display ticket-app-table" id="ticketdatatable">
                    <thead>
                        <tr>
                            <th>
                                <div class="checkbox-wrapper">
                                    <label class="m-0 check-box">
                                        <input id="select-all1" type="checkbox">
                                        <span class="checkmark outline-secondary"></span>
                                    </label>
                                </div>
                            </th>
                            <th>Tracking Number</th>
                            <th>Owner Name</th>
                            <th>Category</th>
                            <th>Date of Deposit</th>
                            <th>Status</th>
                            <th>Total Value</th>
                            <th>Actions</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody id="ticket_key_body">
                        @forelse($vaults as $vault)
                            <tr>
                                <td>
                                    <div class="checkbox-wrapper">
                                        <label class="m-0 check-box">
                                            <input type="checkbox">
                                            <span class="checkmark outline-secondary"></span>
                                        </label>
                                    </div>
                                </td>
                                <td>{{ $vault->id }}</td>
                                <td>
                                    <div class="d-flex align-items-center">
                                        <div class="overflow-hidden h-30 w-30 d-flex-center b-r-50 text-bg-primary me-2">
                                            <img alt="User Avatar" class="img-fluid"
                                                 src="{{ asset('assets/images/avtar/1.png') }}">
                                        </div>
                                        {{ $vault->tracking_number }}
                                    </div>
                                </td>
                                <td>{{ $vault->owner_name }}</td>
                                <td>{{ $vault->category }}</td>
                                <td>{{ $vault->date_of_deposit }}</td>
                                <td><span class="badge text-outline-warning">{{ $vault->status }}</span></td>
                                <td>{{ $vault->total_value }}</td>
                                <td>
                                    <div class="btn-group dropdown-icon-none">
                                        <button aria-expanded="false"
                                                class="border-0 btn icon-btn b-r-4 dropdown-toggle active"
                                                data-bs-auto-close="true" data-bs-toggle="dropdown"
                                                type="button">
                                            <i class="ti ti-dots-vertical"></i>
                                        </button>
                                        <ul class="dropdown-menu">
                                            <li>
                                                <a class="dropdown-item" href="{{ route('admin.vaults.show', $vault->id) }}">
                                                    <i class="ti ti-eye text-primary me-2"></i> View
                                                </a>
                                            </li>
                                            <li>
                                                <a class="dropdown-item" href="{{ route('admin.vaults.edit', $vault->id) }}">
                                                    <i class="ti ti-edit text-success me-2"></i> Edit
                                                </a>
                                            </li>
                                            <li>
                                                <form action="{{ route('admin.vaults.destroy', $vault->id) }}" method="POST" style="display:inline;">
                                                    @csrf
                                                    @method('DELETE')
                                                    <a type="submit" class="btn btn-danger" onclick="return confirm('Are you sure you want to delete this vault?')">Delete</a>
                                                 </form>
                                            </li>
                                        </ul>
                                    </div>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="6" class="text-center">No Vaults found.</td>
                            </tr>
                        @endforelse
                    </tbody>

                </table>

            </div>
        </div>
    </div>
</div>
<!-- ticket table end -->
</div>
<!-- Ticket end -->
</div>

<!-- delete modal   -->



<!-- edit modal  -->

</main>
<!-- Main Section end -->
</div>

<script src="{{ asset('assets/vendor/bootstrap/bootstrap.bundle.min.js') }}"></script>
<script src="{{ asset('assets/vendor/jquery/jquery.min.js') }}"></script>

<script>
    $(document).ready(function () {
        $('#ticketdatatable').DataTable(); // Initialize DataTable if needed

        // Delete user functionality
        $(document).on('click', '.delete-btn', function (e) {
            e.preventDefault();
            let userId = $(this).data('id');

            if (confirm('Are you sure you want to delete this user?')) {
                $.ajax({
                    url: "{{ url('admin/users') }}/" + userId,
                    type: 'DELETE',
                    headers: { 'X-CSRF-TOKEN': '{{ csrf_token() }}' },
                    success: function (response) {
                        alert(response.success);
                        location.reload();
                    }
                });
            }
        });
    });
</script>

@endsection




{{--

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Vaults Management</title>
    <link rel="stylesheet" href="{{ asset('css/app.css') }}">
</head>
<body>
    <div class="container">
        <h1>Vaults Management</h1>
        <a href="{{ route('admin.vaults.create') }}" class="btn btn-primary">Create New Vault</a>
        <table class="table">
            <thead>
                <tr>
                    <th>Tracking Number</th>
                    <th>Description</th>
                    <th>Status</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                @foreach($vaults as $vault)
                    <tr>
                        <td>{{ $vault->tracking_number }}</td>
                        <td>{{ $vault->description }}</td>
                        <td>{{ $vault->status }}</td>
                        <td>
                            <a href="{{ route('admin.vaults.edit', $vault->id) }}" class="btn btn-warning">Edit</a>
                            <form action="{{ route('admin.vaults.destroy', $vault->id) }}" method="POST" style="display:inline;">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-danger">Delete</button>
                            </form>
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</body>
</html> --}}
