
@extends('layouts.amaster')

@section('title', 'Users  ')

@section('content')

<main>

    <div class="container-fluid">
<!-- Breadcrumb start -->
<div class="m-1 row">
<div class="col-12 ">
    <h4 class="main-title">Users</h4>
    <ul class="mb-3 app-line-breadcrumbs">
        <li class="">
            <a href="#" class="f-s-14 f-w-500">
          <span>
            <i class="ph-duotone ph-stack f-s-16"></i>
          </span>
            </a>


        </li>
    </ul>
</div>
</div>
<!-- Breadcrumb end -->

<!-- Ticket start -->
<div class="row ticket-app">



<!-- ticket table-->
<div class="col-12">
    <div class="card">
        <div class="px-0 card-body">

            <div class="col-lg-6 form-contentbox">
                <div class="form-container">
                    <form class="app-form" method="POST" action="{{ route('admin.createUser') }}" enctype="multipart/form-data">
                        @csrf

                        <div class="row">
                            <div class="col-12">
                                <div class="mb-5 text-center text-lg-start">
                                    <h2 class="text-primary f-w-600">Add User Account</h2>
                                    <p> </p>
                                </div>
                            </div>

                            <!-- First Name -->
                            <div class="col-6">
                                <div class="mb-3">
                                    <label for="fname" class="form-label">First Name</label>
                                    <input type="text" class="form-control" name="fname" placeholder="Enter User's First Name" id="fname" required>
                                    <x-input-error :messages="$errors->get('fname')" class="mt-2" />
                                </div>
                            </div>

                            <!-- Last Name -->
                            <div class="col-6">
                                <div class="mb-3">
                                    <label for="lname" class="form-label">Last Name</label>
                                    <input type="text" class="form-control" name="lname" placeholder="Enter User's Last Name" id="lname" required>
                                    <x-input-error :messages="$errors->get('lname')" class="mt-2" />
                                </div>
                            </div>

                            <!-- Mark (Hidden Field) -->
                            <div class="col-12">
                                <div class="mb-3">
                                    <label for="mark" class="form-label"> </label>
                                    <input type="hidden" class="form-control" name="mark" id="mark"  readonly>
                                    <x-input-error :messages="$errors->get('mark')" class="mt-2" />
                                </div>
                            </div>

                            <!-- Phone -->
                            <div class="col-12">
                                <div class="mb-3">
                                    <label for="phone" class="form-label">Phone Number</label>
                                    <input type="tel" class="form-control" name="phone" placeholder="Enter User's Phone Number" id="phone" required>
                                    <x-input-error :messages="$errors->get('phone')" class="mt-2" />
                                </div>
                            </div>

                            <!-- Email -->
                            <div class="col-12">
                                <div class="mb-3">
                                    <label for="email" class="form-label">Email</label>
                                    <input type="email" class="form-control" name="email" placeholder="Enter User's Email" id="email" required>
                                    <x-input-error :messages="$errors->get('email')" class="mt-2" />
                                </div>
                            </div>

                            <!-- Password -->
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="password" class="form-label">Password</label>
                                    <input type="password" class="form-control" name="password" placeholder="Enter User's Password" id="password" required>
                                    <x-input-error :messages="$errors->get('password')" class="mt-2" />
                                </div>
                            </div>

                            <!-- Password Confirmation -->
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="password_confirmation" class="form-label">Confirm Password</label>
                                    <input type="password" class="form-control" name="password_confirmation" placeholder="Confirm User's Password" id="password_confirmation" required>
                                    <x-input-error :messages="$errors->get('password_confirmation')" class="mt-2" />
                                </div>
                            </div>

                            <!-- Terms and Conditions -->
                            <div class="col-12">
                                <div class="gap-3 d-flex justify-content-between">
                                    <div class="mb-3 form-check">
                                        <input class="form-check-input" type="checkbox" value="" id="checkDefault" required>
                                        <label class="form-check-label text-secondary" for="checkDefault">
                                            Accept Terms & Conditions
                                        </label>
                                    </div>
                                </div>
                            </div>

                            <!-- Submit Button -->
                            <div class="col-12">
                                <div class="mb-3">
                                    <button type="submit" role="button" class="btn btn-primary w-100">Create User</button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>


        </div>
    </div>
</div>
<!-- ticket table end -->
</div>
<!-- Ticket end -->
</div>

<!-- delete modal   -->



<!-- edit modal  -->

</main>
<!-- Main Section end -->
</div>



@endsection





