@extends('layouts.trackpage')

@section('title', 'Vault Details - ' . $vault->tracking_number)

@section('content')

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/themify-icons/0.1.0/css/themify-icons.min.css">
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css" rel="stylesheet">

<style>
    .floating-btn {
        position: fixed;
        bottom: 50px;
        right: 20px;
        background-color: #aa7ece;
        color: #fff;
        width: 60px;
        height: 60px;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
        font-size: 24px;
        text-decoration: none;
        border: none;
        cursor: pointer;
        transition: background 0.3s ease, transform 0.2s ease;
    }

    .floating-btn:hover {
        background-color: #b18cb4;
        transform: scale(1.1);
    }

    .countdown-container {
        position: relative;
        width: 150px;
        height: 150px;
        border-radius: 50%;
        display: flex;
        justify-content: center;
        align-items: center;
        font-size: 18px;
        color: #333;
        font-weight: bold;
        text-align: center;
        background: #e5e5e5;
    }

    .countdown-text {
        position: absolute;
        font-size: 16px;
        z-index: 10;
    }

    .circle {
        width: 100%;
        height: 100%;
        position: absolute;
        background: conic-gradient(#22bd6f 0deg, #e5e5e5 0deg 100%);
        border-radius: 50%;
        transition: background 0.5s ease-in-out;
    }
</style>

<main>
    <div class="container-fluid">
        <div class="m-1 row">
            <div class="col-12">
                <h4 class="main-title">Vault Details</h4>
            </div>
        </div>

        <div class="row order-details">
            <div class="col-xxl-9">
                <div class="row">
                    <div class="col-lg-6">
                        <div class="card order-details-card">
                            <div class="card-header">
                                <h5>Vault Information (#{{ $vault->tracking_number }})</h5>
                            </div>
                            <div class="card-body">
                                <p><strong>Owner Name:</strong> {{ $vault->owner_name }}</p>
                                <p><strong>Next of Kin:</strong> {{ $vault->next_of_kin }}</p>
                                <p><strong>Category:</strong> {{ $vault->category }}</p>
                                <p><strong>Items:</strong> {{ $vault->items }}</p>
                                <p><strong>Weight:</strong> {{ $vault->weight }}</p>
                                <p><strong>Quantity:</strong> {{ $vault->quantity }}</p>
                                <p><strong>Total Value:</strong> {{ $vault->total_value }}</p>
                                <p><strong>Description:</strong> {{ $vault->description }}</p>
                                <p><strong>Status:</strong> {{ $vault->status }}</p>
                                <p><strong>Date of Deposit:</strong> {{ $vault->date_of_deposit }}</p>
                                <p><strong>Created At:</strong> {{ $vault->created_at->format('d M, Y h:i A') }}</p>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-6">
                        <div class="card order-details-card">
                            <div class="card-header">
                                <h5>Vault Image</h5>
                            </div>
                            <div class="text-center card-body">
                                @if($vault->image)
                                    <img src="{{ asset('storage/' . $vault->image) }}" alt="Vault Image" style="max-width:100%; height:auto;">
                                @else
                                    <p>No image available.</p>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>

                <div class="mt-3 card">
                    <div class="card-header">
                        <h5>Tracking Countdown</h5>
                    </div>
                    <div class="text-center card-body">
                        <div id="countdownDisplay" class="countdown-container">
                            <div class="circle" id="progressCircle"></div>
                            <div class="countdown-text" id="countdownText">
                                ⏳ <br />
                                <span>Loading...</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-xxl-3">
                <div class="card equal-card">
                    <div class="card-header">
                        <h5>Vault Status History</h5>
                    </div>
                    <div class="card-body">
                        <ul class="app-timeline-box">
                            <li class="timeline-section">
                                <div class="timeline-icon">
                                    <span class="text-light-success h-35 w-35 d-flex-center b-r-50">
                                        <i class="ti-check f-s-20"></i>
                                    </span>
                                </div>
                                <div class="timeline-content bg-light-success b-1-success">
                                    <h6 class="text-success">{{ $vault->status }}</h6>
                                    <p class="text-secondary">{{ $vault->updated_at->format('D, d M Y - h:i A') }}</p>
                                    <p>{{ $vault->description ?? 'No additional details.' }}</p>
                                </div>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>

        </div>
    </div>
</main>

<script>
    function startCountdown(targetDate) {
        const countdownText = document.getElementById('countdownText');
        const progressCircle = document.getElementById('progressCircle');

        const updateCountdown = () => {
            const now = new Date();
            const distance = new Date(targetDate) - now;

            if (distance <= 0) {
                countdownText.innerHTML = "✅ Completed";
                progressCircle.style.background = "conic-gradient(#22bd6f 360deg, #e5e5e5 0deg)";
                return;
            }

            const days = Math.floor(distance / (1000 * 60 * 60 * 24));
            const hours = Math.floor((distance / (1000 * 60 * 60)) % 24);
            const minutes = Math.floor((distance / (1000 * 60)) % 60);
            const seconds = Math.floor((distance / 1000) % 60);

            const totalDuration = (new Date(targetDate) - new Date("{{ $vault->created_at }}"));
            const elapsed = totalDuration - distance;
            const progress = (elapsed / totalDuration) * 360;

            progressCircle.style.background = `conic-gradient(#22bd6f ${progress}deg, #e5e5e5 ${progress}deg 360deg)`;

            countdownText.innerHTML = `⏳ ${days}d ${hours}h<br>${minutes}m ${seconds}s left`;
        };

        updateCountdown();
        setInterval(updateCountdown, 1000);
    }

    document.addEventListener('DOMContentLoaded', () => {
        const targetDate = "{{ $vault->updated_at->addDays(30)->format('Y-m-d H:i:s') }}";
        startCountdown(targetDate);
    });
</script>

@endsection
