<?php

use App\Http\Controllers\ProfileController;
use Illuminate\Support\Facades\Route;

// Route::get('/', function () {
//     return view('welcome');
// });

Route::get('/dashboard', function () {
    return view('dashboard');
})->middleware(['auth', 'verified'])->name('dashboard');

use App\Http\Controllers\Admin\VaultController;
use App\Http\Controllers\VaultTrackingController;


Route::get('/', [VaultTrackingController::class, 'index'])->name('track.index');
Route::get('/track', [VaultTrackingController::class, 'index'])->name('track.index');
Route::post('/track', [VaultTrackingController::class, 'show'])->name('track.show');

Route::middleware(['auth'])->prefix('admin')->name('admin.')->group(function () {
    Route::resource('vaults', VaultController::class);
});

Route::get('/admin/vaults', [VaultController::class, 'index'])->name('admin.vaults.index');

Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});

require __DIR__ . '/auth.php';
