

<?php $__env->startSection('title', 'View Vault'); ?>

<?php $__env->startSection('content'); ?>

<main>
    <div class="container-fluid">
        <!-- Breadcrumb start -->
        <div class="m-1 row">
            <div class="col-12">
                <h4 class="main-title">Vault Details</h4>
                <ul class="mb-3 app-line-breadcrumbs">
                    <li>
                        <a href="<?php echo e(route('admin.vaults.index')); ?>" class="f-s-14 f-w-500">
                            <span>
                                <i class="ph-duotone ph-stack f-s-16"></i> Vaults
                            </span>
                        </a>
                    </li>
                </ul>
            </div>
        </div>
        <!-- Breadcrumb end -->

        <!-- Vault details start -->
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="px-0 card-body">
                        <div class="col-lg-8 form-contentbox">
                            <div class="form-container">
                                <div class="row">
                                    <div class="col-12">
                                        <div class="mb-5 text-center text-lg-start">
                                            <h2 class="text-primary f-w-600">Vault #<?php echo e($vault->tracking_number); ?></h2>
                                        </div>
                                    </div>

                                    <!-- Tracking Number -->
                                    <div class="mb-3 col-md-6">
                                        <label class="form-label">Tracking Number</label>
                                        <p><?php echo e($vault->tracking_number); ?></p>
                                    </div>

                                    <!-- Owner Name -->
                                    <div class="mb-3 col-md-6">
                                        <label class="form-label">Owner Name</label>
                                        <p><?php echo e($vault->owner_name); ?></p>
                                    </div>

                                    <!-- Next of Kin -->
                                    <div class="mb-3 col-md-6">
                                        <label class="form-label">Next of Kin</label>
                                        <p><?php echo e($vault->next_of_kin); ?></p>
                                    </div>

                                    <!-- Day Price -->
                                    <div class="mb-3 col-md-3">
                                        <label class="form-label">Day Price</label>
                                        <p><?php echo e($vault->day_price); ?></p>
                                    </div>

                                    <!-- Month Price -->
                                    <div class="mb-3 col-md-3">
                                        <label class="form-label">Month Price</label>
                                        <p><?php echo e($vault->month_price); ?></p>
                                    </div>

                                    <!-- Date of Deposit -->
                                    <div class="mb-3 col-md-6">
                                        <label class="form-label">Date of Deposit</label>
                                        <p><?php echo e($vault->date_of_deposit); ?></p>
                                    </div>

                                    <!-- Category -->
                                    <div class="mb-3 col-md-6">
                                        <label class="form-label">Category</label>
                                        <p><?php echo e($vault->category); ?></p>
                                    </div>

                                    <!-- Items -->
                                    <div class="mb-3 col-12">
                                        <label class="form-label">Items</label>
                                        <p><?php echo e($vault->items); ?></p>
                                    </div>

                                    <!-- Weight -->
                                    <div class="mb-3 col-md-4">
                                        <label class="form-label">Weight (kg)</label>
                                        <p><?php echo e($vault->weight); ?></p>
                                    </div>

                                    <!-- Quantity -->
                                    <div class="mb-3 col-md-4">
                                        <label class="form-label">Quantity</label>
                                        <p><?php echo e($vault->quantity); ?></p>
                                    </div>

                                    <!-- Total Value -->
                                    <div class="mb-3 col-md-4">
                                        <label class="form-label">Total Value</label>
                                        <p><?php echo e($vault->total_value); ?></p>
                                    </div>

                                    <!-- Description -->
                                    <div class="mb-3 col-12">
                                        <label class="form-label">Description</label>
                                        <p><?php echo e($vault->description); ?></p>
                                    </div>

                                    <!-- Status -->
                                    <div class="mb-3 col-md-6">
                                        <label class="form-label">Status</label>
                                        <p><?php echo e(ucfirst($vault->status)); ?></p>
                                    </div>

                                    <!-- Image -->
                                    <div class="mb-3 col-md-6">
                                        <label class="form-label">Vault Image</label><br>
                                        <?php if($vault->image): ?>
                                            <img src="<?php echo e(asset('storage/' . $vault->image)); ?>" alt="Vault Image" style="max-width:200px;">
                                        <?php else: ?>
                                            <p>No image available.</p>
                                        <?php endif; ?>
                                    </div>

                                    <!-- Created At -->
                                    <div class="mb-3 col-md-6">
                                        <label class="form-label">Created At</label>
                                        <p><?php echo e($vault->created_at->format('d M, Y h:i A')); ?></p>
                                    </div>

                                    <!-- Updated At -->
                                    <div class="mb-3 col-md-6">
                                        <label class="form-label">Updated At</label>
                                        <p><?php echo e($vault->updated_at->format('d M, Y h:i A')); ?></p>
                                    </div>

                                    <!-- Back Button -->
                                    <div class="mb-3 col-12">
                                        <a href="<?php echo e(route('admin.vaults.index')); ?>" class="btn btn-secondary w-100">Back to Vaults List</a>
                                    </div>

                                    <!-- Edit Button -->
                                    <div class="mb-3 col-12">
                                        <a href="<?php echo e(route('admin.vaults.edit', $vault->id)); ?>" class="btn btn-warning w-100">Edit Vault</a>
                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Vault details end -->
    </div>
</main>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.amaster', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\Work\WEB DEVELOPMENT\MainLaravel\pa\vault\resources\views/admin/vaults/show.blade.php ENDPATH**/ ?>