<?php $__env->startSection('title', 'Edit Vault'); ?>

<?php $__env->startSection('content'); ?>

<main>
    <div class="container-fluid">
        <!-- Breadcrumb start -->
        <div class="m-1 row">
            <div class="col-12">
                <h4 class="main-title">Edit Vault</h4>
                <ul class="mb-3 app-line-breadcrumbs">
                    <li>
                        <a href="<?php echo e(route('admin.vaults.index')); ?>" class="f-s-14 f-w-500">
                            <span>
                                <i class="ph-duotone ph-stack f-s-16"></i> Vaults
                            </span>
                        </a>
                    </li>
                </ul>
            </div>
        </div>
        <!-- Breadcrumb end -->

        <!-- Vault edit form start -->
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="px-0 card-body">
                        <div class="col-lg-8 form-contentbox">
                            <div class="form-container">
                                <form class="app-form" method="POST" action="<?php echo e(route('admin.vaults.update', $vault->id)); ?>" enctype="multipart/form-data">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('PUT'); ?>

                                    <div class="row">
                                        <div class="col-12">
                                            <div class="mb-5 text-center text-lg-start">
                                                <h2 class="text-primary f-w-600">Edit Vault #<?php echo e($vault->tracking_number); ?></h2>
                                            </div>
                                        </div>

                                        <!-- Tracking Number -->
                                        <div class="mb-3 col-md-6">
                                            <label class="form-label">Tracking Number</label>
                                            <input type="text" class="form-control" name="tracking_number" value="<?php echo e(old('tracking_number', $vault->tracking_number)); ?>" required>
                                        </div>

                                        <!-- Owner Name -->
                                        <div class="mb-3 col-md-6">
                                            <label class="form-label">Owner Name</label>
                                            <input type="text" class="form-control" name="owner_name" value="<?php echo e(old('owner_name', $vault->owner_name)); ?>" required>
                                        </div>

                                        <!-- Next of Kin -->
                                        <div class="mb-3 col-md-6">
                                            <label class="form-label">Next of Kin</label>
                                            <input type="text" class="form-control" name="next_of_kin" value="<?php echo e(old('next_of_kin', $vault->next_of_kin)); ?>">
                                        </div>

                                        <!-- Day Price -->
                                        <div class="mb-3 col-md-3">
                                            <label class="form-label">Day Price</label>
                                            <input type="number" step="0.01" class="form-control" name="day_price" value="<?php echo e(old('day_price', $vault->day_price)); ?>">
                                        </div>

                                        <!-- Month Price -->
                                        <div class="mb-3 col-md-3">
                                            <label class="form-label">Month Price</label>
                                            <input type="number" step="0.01" class="form-control" name="month_price" value="<?php echo e(old('month_price', $vault->month_price)); ?>">
                                        </div>

                                        <!-- Date of Deposit -->
                                        <div class="mb-3 col-md-6">
                                            <label class="form-label">Date of Deposit</label>
                                            <input type="date" class="form-control" name="date_of_deposit" value="<?php echo e(old('date_of_deposit', $vault->date_of_deposit)); ?>" required>
                                        </div>

                                        <!-- Category -->
                                        <div class="mb-3 col-md-6">
                                            <label class="form-label">Category</label>
                                            <input type="text" class="form-control" name="category" value="<?php echo e(old('category', $vault->category)); ?>">
                                        </div>

                                        <!-- Items -->
                                        <div class="mb-3 col-12">
                                            <label class="form-label">Items</label>
                                            <textarea class="form-control" name="items"><?php echo e(old('items', $vault->items)); ?></textarea>
                                        </div>

                                        <!-- Weight -->
                                        <div class="mb-3 col-md-4">
                                            <label class="form-label">Weight (kg)</label>
                                            <input type="number" step="0.01" class="form-control" name="weight" value="<?php echo e(old('weight', $vault->weight)); ?>">
                                        </div>

                                        <!-- Quantity -->
                                        <div class="mb-3 col-md-4">
                                            <label class="form-label">Quantity</label>
                                            <input type="number" class="form-control" name="quantity" value="<?php echo e(old('quantity', $vault->quantity)); ?>">
                                        </div>

                                        <!-- Total Value -->
                                        <div class="mb-3 col-md-4">
                                            <label class="form-label">Total Value</label>
                                            <input type="number" step="0.01" class="form-control" name="total_value" value="<?php echo e(old('total_value', $vault->total_value)); ?>">
                                        </div>

                                        <!-- Description -->
                                        <div class="mb-3 col-12">
                                            <label class="form-label">Description</label>
                                            <textarea class="form-control" name="description"><?php echo e(old('description', $vault->description)); ?></textarea>
                                        </div>

                                        <!-- Status -->
                                        <div class="mb-3 col-md-6">
                                            <label class="form-label">Status</label>
                                            <select class="form-control" name="status">
                                                <option value="stored" <?php echo e($vault->status == 'stored' ? 'selected' : ''); ?>>Stored</option>
                                                <option value="released" <?php echo e($vault->status == 'released' ? 'selected' : ''); ?>>Released</option>
                                            </select>
                                        </div>

                                        <!-- Image -->
                                        <div class="mb-3 col-md-6">
                                            <label class="form-label">Vault Image</label>
                                            <input type="file" class="form-control" name="image">
                                            <?php if($vault->image): ?>
                                                <small>Current Image:</small><br>
                                                <img src="<?php echo e(asset('storage/' . $vault->image)); ?>" alt="Vault Image" style="max-width:150px;">
                                            <?php endif; ?>
                                        </div>

                                        <!-- Submit Button -->
                                        <div class="mb-3 col-12">
                                            <button type="submit" class="btn btn-primary w-100">Update Vault</button>
                                        </div>

                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Vault edit form end -->
    </div>
</main>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.amaster', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\Work\WEB DEVELOPMENT\MainLaravel\pa\vault\resources\views/admin/vaults/edit.blade.php ENDPATH**/ ?>