<?php $__env->startSection('title', 'Create Vault'); ?>

<?php $__env->startSection('content'); ?>

<main>
    <div class="container-fluid">
        <!-- Breadcrumb start -->
        <div class="m-1 row">
            <div class="col-12">
                <h4 class="main-title">Create Vault</h4>
                <ul class="mb-3 app-line-breadcrumbs">
                    <li>
                        <a href="<?php echo e(route('admin.vaults.index')); ?>" class="f-s-14 f-w-500">
                            <span>
                                <i class="ph-duotone ph-stack f-s-16"></i> Vaults
                            </span>
                        </a>
                    </li>
                </ul>
            </div>
        </div>
        <!-- Breadcrumb end -->

        <!-- Vault creation form start -->
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="px-0 card-body">
                        <div class="col-lg-8 form-contentbox">
                            <div class="form-container">
                                <form class="app-form" method="POST" action="<?php echo e(route('admin.vaults.store')); ?>" enctype="multipart/form-data">
                                    <?php echo csrf_field(); ?>

                                    <div class="row">
                                        <div class="col-12">
                                            <div class="mb-5 text-center text-lg-start">
                                                <h2 class="text-primary f-w-600">Add New Vault</h2>
                                            </div>
                                        </div>

                                        <!-- Tracking Number -->
                                        <div class="mb-3 col-md-6">
                                            <label class="form-label">Tracking Number</label>
                                            <input type="text" class="form-control" name="tracking_number" placeholder="Enter Tracking Number" required>
                                        </div>

                                        <!-- Owner Name -->
                                        <div class="mb-3 col-md-6">
                                            <label class="form-label">Owner Name</label>
                                            <input type="text" class="form-control" name="owner_name" placeholder="Enter Owner Name" required>
                                        </div>

                                        <!-- Next of Kin -->
                                        <div class="mb-3 col-md-6">
                                            <label class="form-label">Next of Kin</label>
                                            <input type="text" class="form-control" name="next_of_kin" placeholder="Enter Next of Kin">
                                        </div>

                                        <!-- Day Price -->
                                        <div class="mb-3 col-md-3">
                                            <label class="form-label">Day Price</label>
                                            <input type="number" step="0.01" class="form-control" name="day_price" placeholder="Day Price">
                                        </div>

                                        <!-- Month Price -->
                                        <div class="mb-3 col-md-3">
                                            <label class="form-label">Month Price</label>
                                            <input type="number" step="0.01" class="form-control" name="month_price" placeholder="Month Price">
                                        </div>

                                        <!-- Date of Deposit -->
                                        <div class="mb-3 col-md-6">
                                            <label class="form-label">Date of Deposit</label>
                                            <input type="date" class="form-control" name="date_of_deposit" required>
                                        </div>

                                        <!-- Category -->
                                        <div class="mb-3 col-md-6">
                                            <label class="form-label">Category</label>
                                            <input type="text" class="form-control" name="category" placeholder="Category">
                                        </div>

                                        <!-- Items -->
                                        <div class="mb-3 col-12">
                                            <label class="form-label">Items</label>
                                            <textarea class="form-control" name="items" placeholder="List items"></textarea>
                                        </div>

                                        <!-- Weight -->
                                        <div class="mb-3 col-md-4">
                                            <label class="form-label">Weight (kg)</label>
                                            <input type="number" step="0.01" class="form-control" name="weight" placeholder="Weight">
                                        </div>

                                        <!-- Quantity -->
                                        <div class="mb-3 col-md-4">
                                            <label class="form-label">Quantity</label>
                                            <input type="number" class="form-control" name="quantity" placeholder="Quantity">
                                        </div>

                                        <!-- Total Value -->
                                        <div class="mb-3 col-md-4">
                                            <label class="form-label">Total Value</label>
                                            <input type="number" step="0.01" class="form-control" name="total_value" placeholder="Total Value">
                                        </div>

                                        <!-- Description -->
                                        <div class="mb-3 col-12">
                                            <label class="form-label">Description</label>
                                            <textarea class="form-control" name="description" placeholder="Description"></textarea>
                                        </div>

                                        <!-- Status -->
                                        <div class="mb-3 col-md-6">
                                            <label class="form-label">Status</label>
                                            <select class="form-control" name="status">
                                                <option value="stored">Stored</option>
                                                <option value="released">Released</option>
                                            </select>
                                        </div>

                                        <!-- Image -->
                                        <div class="mb-3 col-md-6">
                                            <label class="form-label">Vault Image</label>
                                            <input type="file" class="form-control" name="image">
                                        </div>

                                        <!-- Terms and Conditions -->
                                        <div class="mb-3 col-12 form-check">
                                            <input class="form-check-input" type="checkbox" id="termsCheck" required>
                                            <label class="form-check-label text-secondary" for="termsCheck">
                                                Accept Terms & Conditions
                                            </label>
                                        </div>

                                        <!-- Submit Button -->
                                        <div class="mb-3 col-12">
                                            <button type="submit" class="btn btn-primary w-100">Create Vault</button>
                                        </div>

                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Vault creation form end -->
    </div>
</main>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.amaster', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\Work\WEB DEVELOPMENT\MainLaravel\pa\vault\resources\views/admin/vaults/create.blade.php ENDPATH**/ ?>