<?php $__env->startSection('title', ' Dashboard'); ?>

<?php $__env->startSection('content'); ?>

<?php if(session('success')): ?>
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <?php echo e(session('success')); ?>

        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
<?php endif; ?>





<main>

    <div class="container-fluid">
<!-- Breadcrumb start -->
<div class="m-1 row">
<div class="col-12 ">
    <h4 class="main-title">Users</h4>
    <ul class="mb-3 app-line-breadcrumbs">
        <li class="">
            <a href="#" class="f-s-14 f-w-500">
          <span>
            <i class="ph-duotone ph-stack f-s-16"></i>
          </span>
            </a>


        </li>
    </ul>
</div>
</div>
<!-- Breadcrumb end -->
<a href="<?php echo e(route('admin.vaults.create')); ?>" class="mb-3 btn btn-primary">
    Add New User
</a>
<!-- Ticket start -->
<div class="row ticket-app">



<!-- ticket table-->
<div class="col-12">
    <div class="card">
        <div class="px-0 card-body">
            <div class="table-responsive app-scroll app-datatable-default">
                <table class="w-100 display ticket-app-table" id="ticketdatatable">
                    <thead>
                        <tr>
                            <th>
                                <div class="checkbox-wrapper">
                                    <label class="m-0 check-box">
                                        <input id="select-all1" type="checkbox">
                                        <span class="checkmark outline-secondary"></span>
                                    </label>
                                </div>
                            </th>
                            <th>Tracking Number</th>
                            <th>Owner Name</th>
                            <th>Category</th>
                            <th>Date of Deposit</th>
                            <th>Status</th>
                            <th>Total Value</th>
                            <th>Actions</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody id="ticket_key_body">
                        <?php $__empty_1 = true; $__currentLoopData = $vaults; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $vault): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td>
                                    <div class="checkbox-wrapper">
                                        <label class="m-0 check-box">
                                            <input type="checkbox">
                                            <span class="checkmark outline-secondary"></span>
                                        </label>
                                    </div>
                                </td>
                                <td><?php echo e($vault->id); ?></td>
                                <td>
                                    <div class="d-flex align-items-center">
                                        <div class="overflow-hidden h-30 w-30 d-flex-center b-r-50 text-bg-primary me-2">
                                            <img alt="User Avatar" class="img-fluid"
                                                 src="<?php echo e(asset('assets/images/avtar/1.png')); ?>">
                                        </div>
                                        <?php echo e($vault->tracking_number); ?>

                                    </div>
                                </td>
                                <td><?php echo e($vault->owner_name); ?></td>
                                <td><?php echo e($vault->category); ?></td>
                                <td><?php echo e($vault->date_of_deposit); ?></td>
                                <td><span class="badge text-outline-warning"><?php echo e($vault->status); ?></span></td>
                                <td><?php echo e($vault->total_value); ?></td>
                                <td>
                                    <div class="btn-group dropdown-icon-none">
                                        <button aria-expanded="false"
                                                class="border-0 btn icon-btn b-r-4 dropdown-toggle active"
                                                data-bs-auto-close="true" data-bs-toggle="dropdown"
                                                type="button">
                                            <i class="ti ti-dots-vertical"></i>
                                        </button>
                                        <ul class="dropdown-menu">
                                            <li>
                                                <a class="dropdown-item" href="<?php echo e(route('admin.vaults.show', $vault->id)); ?>">
                                                    <i class="ti ti-eye text-primary me-2"></i> View
                                                </a>
                                            </li>
                                            <li>
                                                <a class="dropdown-item" href="<?php echo e(route('admin.vaults.edit', $vault->id)); ?>">
                                                    <i class="ti ti-edit text-success me-2"></i> Edit
                                                </a>
                                            </li>
                                            <li>
                                                <form action="<?php echo e(route('admin.vaults.destroy', $vault->id)); ?>" method="POST" style="display:inline;">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('DELETE'); ?>
                                                    <a type="submit" class="btn btn-danger" onclick="return confirm('Are you sure you want to delete this vault?')">Delete</a>
                                                 </form>
                                            </li>
                                        </ul>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="6" class="text-center">No Vaults found.</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>

                </table>

            </div>
        </div>
    </div>
</div>
<!-- ticket table end -->
</div>
<!-- Ticket end -->
</div>

<!-- delete modal   -->



<!-- edit modal  -->

</main>
<!-- Main Section end -->
</div>

<script src="<?php echo e(asset('assets/vendor/bootstrap/bootstrap.bundle.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/vendor/jquery/jquery.min.js')); ?>"></script>

<script>
    $(document).ready(function () {
        $('#ticketdatatable').DataTable(); // Initialize DataTable if needed

        // Delete user functionality
        $(document).on('click', '.delete-btn', function (e) {
            e.preventDefault();
            let userId = $(this).data('id');

            if (confirm('Are you sure you want to delete this user?')) {
                $.ajax({
                    url: "<?php echo e(url('admin/users')); ?>/" + userId,
                    type: 'DELETE',
                    headers: { 'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>' },
                    success: function (response) {
                        alert(response.success);
                        location.reload();
                    }
                });
            }
        });
    });
</script>

<?php $__env->stopSection(); ?>






<?php echo $__env->make('layouts.amaster', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\Work\WEB DEVELOPMENT\MainLaravel\pa\vault\resources\views/admin/vaults/index.blade.php ENDPATH**/ ?>